/*
 * Copyright (C) 2013 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef APIPageHandle_h
#define APIPageHandle_h

#include "APIObject.h"
#include <wtf/Ref.h>

namespace IPC {
class Decoder;
class Encoder;
}

namespace API {

class PageHandle : public ObjectImpl<Object::Type::PageHandle> {
public:
    static Ref<PageHandle> create(uint64_t pageID);
    static Ref<PageHandle> createAutoconverting(uint64_t pageID);
    virtual ~PageHandle();

    uint64_t pageID() const { return m_pageID; }
    bool isAutoconverting() const { return m_isAutoconverting; }

    void encode(IPC::Encoder&) const;
    static bool decode(IPC::Decoder&, RefPtr<Object>&);

private:
    explicit PageHandle(uint64_t pageID, bool isAutoconverting);

    const uint64_t m_pageID;
    const bool m_isAutoconverting;
};

} // namespace API

#endif // APIPageHandle_h
